
import gurobi

def solve_basketball_shot_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(lb=5, name="LongShots")  # At least 5 long shots
    M = model.addVar(lb=0, name="MidRangeShots")

    # Objective function: Maximize points scored
    model.setObjective(0.75*L + 0.8*M, gurobi.GRB.MAXIMIZE)

    # Constraint: Score at least 95 points
    model.addConstr(0.75*L + 0.8*M >= 95, name="ScoreConstraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Long Shots: {L.varValue}")
        print(f"Mid-range Shots: {M.varValue}")
        print(f"Total Score: {0.75*L.varValue + 0.8*M.varValue}")
    else:
        print("No optimal solution found.")

solve_basketball_shot_optimization()
