
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Paper Production")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="lined_paper")
y = model.addVar(vtype=GRB.CONTINUOUS, name="unlined_paper")

# Set objective function
model.setObjective(5*x + 3*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + y <= 400, "printing_constraint")
model.addConstr(5*x + 2*y <= 400, "scanning_constraint")
model.addConstr(x >= 0, "lined_nonnegativity")
model.addConstr(y >= 0, "unlined_nonnegativity")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal:.2f}")
    print(f"Lined Paper Reams: {x.x:.2f}")
    print(f"Unlined Paper Reams: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

