
from gurobipy import *

# Create a new model
model = Model("Paper Production")

# Define the decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lined_paper")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="unlined_paper")

# Define the objective function: Maximize profit
model.setObjective(5*x + 3*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + y <= 400, "printing_machine")
model.addConstr(5*x + 2*y <= 400, "scanning_machine")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produce {x.x} reams of lined paper")
    print(f"Produce {y.x} reams of unlined paper")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("No optimal solution found")

