
import gurobi

def solve_paper_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    L = model.addVar(lb=0, name="Lined_Paper")
    U = model.addVar(lb=0, name="Unlined_Paper")

    # Define the objective function
    model.setObjective(5*L + 3*U, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*L + U <= 400, name="Printing_Constraint")
    model.addConstr(5*L + 2*U <= 400, name="Scanning_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Lined Paper = {L.varValue}, Unlined Paper = {U.varValue}")
        print(f"Maximum Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_paper_production_problem()
