
import gurobipy as gp

# Create a new model
m = gp.Model("Resource Allocation")

# Create decision variables
x = m.addVar(lb=0, name="solar_acres")  # Acres of solar panels
y = m.addVar(lb=0, name="windmill_acres") # Acres of windmills

# Set objective function
m.setObjective(500*x + 1000*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 120, "land_constraint")
m.addConstr(20*x + 40*y <= 2000, "resource_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Solar Panels Acres: {x.x}")
    print(f"  Windmill Acres: {y.x}")
    print(f"  Total Savings: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

