
from gurobipy import *

# Create a new model
m = Model("Solar_Wind_Optimization")

# Define variables
x = m.addVar(name="solar_panels", lb=0)  # Acres of solar panels
y = m.addVar(name="windmills", lb=0)     # Acres of windmills

# Add constraints
m.addConstr(x + y <= 120, name="land_constraint")  # Total land constraint
m.addConstr(20*x + 40*y <= 2000, name="resource_constraint")  # Resource constraint

# Define the objective function to maximize savings (profit)
m.setObjective(500*x + 1000*y, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of solar panels: {x.x}")
    print(f"Acres of windmills: {y.x}")
    print(f"Maximum savings (profit): ${m.objVal:.2f}")
else:
    print("No optimal solution found. The model may be infeasible.")
