
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="solar_panels_acres")
    y = model.addVar(lb=0, name="windmills_acres")

    # Objective function: Maximize savings
    model.setObjective(500*x + 1000*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 120, name="land_constraint")
    model.addConstr(20*x + 40*y <= 2000, name="resource_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres for solar panels: {x.varValue}")
        print(f"Optimal acres for windmills: {y.varValue}")
        print(f"Max savings: ${model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
