
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Advertising Optimization")

# Decision variables representing the number of ads on each platform
planes = model.addVar(vtype=GRB.INTEGER, name="planes")
blimps = model.addVar(vtype=GRB.INTEGER, name="blimps")
balloons = model.addVar(vtype=GRB.INTEGER, name="balloons")

# Objective function: Maximize total viewership
model.setObjective(100000 * planes + 50000 * blimps + 20000 * balloons, GRB.MAXIMIZE)

# Constraints
model.addConstr(5000 * planes + 2000 * blimps + 1000 * balloons <= 50000, "Budget")  # Budget constraint
model.addConstr(planes <= 5, "Plane Limit")  # Airline industry limit
model.addConstr(balloons <= 0.5 * (planes + blimps + balloons), "Balloon Proportion")  # At most half the ads on balloons
model.addConstr(blimps >= 0.2 * (planes + blimps + balloons), "Blimp Proportion")  # At least 20% of ads on blimps

# Non-negativity constraints are implicitly added by Gurobi for integer variables

# Optimize the model
model.optimize()

# Print the optimal solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal Viewership: {model.objVal}")
    print(f"Number of Plane Ads: {planes.x}")
    print(f"Number of Blimp Ads: {blimps.x}")
    print(f"Number of Balloon Ads: {balloons.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

