
from gurobipy import *

# Create a model
m = Model("advertisement_optimization")

# Define decision variables
P = m.addVar(vtype=GRB.INTEGER, name="ads_on_planes")
B = m.addVar(vtype=GRB.INTEGER, name="ads_on_blimps")
H = m.addVar(vtype=GRB.INTEGER, name="ads_on_hot_air_balloons")

# Objective function: Maximize viewership
m.setObjective(100000*P + 50000*B + 20000*H, GRB.MAXIMIZE)

# Constraints
m.addConstr(5000*P + 2000*B + 1000*H <= 50000, name="budget_constraint")
m.addConstr(P <= 5, name="plane_ads_limit")
m.addConstr(H <= 0.5*(P + B + H), name="hot_air_balloons_limit")
m.addConstr(B >= 0.2*(P + B + H), name="blimps_minimum")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ads on planes: {P.x}")
    print(f"Ads on blimps: {B.x}")
    print(f"Ads on hot air balloons: {H.x}")
else:
    print("No optimal solution found")
