
import gurobipy as gp

# Create a new model
m = gp.Model("Advertising")

# Decision variables
P = m.addVar(lb=0, ub=5, name="Plane_ads")
B = m.addVar(lb=0, ub=5, name="Blimp_ads")
H = m.addVar(lb=0, ub=5, name="Hot_Air_Balloon_ads")

# Objective: Maximize viewership
m.setObjective(100000*P + 50000*B + 20000*H, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(5000*P + 2000*B + 1000*H <= 50000, name="Budget")

# Maximum ads per type is inherently handled by variable bounds

# Hot air balloon limit: at most half of total ads
m.addConstr(0.5*P + 0.5*B - 0.5*H >= 0, name="Hot_Air_Balloon_Limit")

# Blimp minimum: at least 20% of total ads
m.addConstr(B - 0.2*P - 0.2*B - 0.2*H >= 0, name="Blimp_Minimum")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Plane ads: {P.varValue}")
    print(f"Blimp ads: {B.varValue}")
    print(f"Hot Air Balloon ads: {H.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("No optimal solution found")
