
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Energy Drinks")

# Create decision variables
r = model.addVar(vtype=GRB.CONTINUOUS, name="r") # Allow fractional cans for now
m = model.addVar(vtype=GRB.CONTINUOUS, name="m")

# Set objective function
model.setObjective(4*r + 7*m, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*r + 5*m >= 30, "Caffeine")
model.addConstr(5*r + 8*m >= 50, "Water")
model.addConstr(r >= 0, "r_nonneg")
model.addConstr(m >= 0, "m_nonneg")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal number of R cans: {r.x}")
    print(f"Optimal number of M cans: {m.x}")
    print(f"Minimum cost: ${model.objVal}")

    # Round to nearest integer if necessary (since you can't buy parts of cans)
    r_int = round(r.x)
    m_int = round(m.x)

    # Recheck constraints with integer values (important!)
    if 2*r_int + 5*m_int >= 30 and 5*r_int + 8*m_int >= 50:
        cost_int = 4*r_int + 7*m_int
        print("\nInteger Solution:")
        print(f"Number of R cans: {r_int}")
        print(f"Number of M cans: {m_int}")
        print(f"Minimum cost: ${cost_int}")
    else:
        print("\nRounding to nearest integer resulted in an infeasible solution.  Further analysis is required.")


