
from gurobipy import *

# Create a new model
m = Model("Energy_Drink_Problem")

# Define the decision variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="EnergyDrinkR", lb=0)
M = m.addVar(vtype=GRB.CONTINUOUS, name="EnergyDrinkM", lb=0)

# Set the objective function
m.setObjective(4*R + 7*M, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*R + 5*M >= 30, "Caffeine_Requirement")
m.addConstr(5*R + 8*M >= 50, "Water_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {R.x} cans of Energy Drink R")
    print(f"Buy {M.x} cans of Energy Drink M")
    print(f"Total cost: ${4*R.x + 7*M.x}")
else:
    print("No optimal solution found")

