
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("energy_drink_problem")

# Define the variables
R = model.addVar(vtype=GRB.INTEGER, name="R")
M = model.addVar(vtype=GRB.INTEGER, name="M")

# Objective function: Minimize 4R + 7M
model.setObjective(4*R + 7*M, GRB.MINIMIZE)

# Constraints
model.addConstr(2*R + 5*M >= 30, name="caffeine_requirement")
model.addConstr(5*R + 8*M >= 50, name="water_requirement")

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: R = {R.varValue}, M = {M.varValue}")
    print(f"Minimum cost: ${4*R.varValue + 7*M.varValue}")
else:
    print("The model is infeasible or no solution exists.")
