
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PaintProduction")

# Create variables
x1 = model.addVar(lb=0, name="OilPaint")
x2 = model.addVar(lb=0, name="AcrylicPaint")
x3 = model.addVar(lb=0, name="WatercolorPaint")

# Set objective function
model.setObjective(150*x1 + 180*x2 + 220*x3, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6.5*x1 + 8*x2 + 16*x3 <= 350, "DyeConstraint")
model.addConstr(15*x1 + 12*x2 + 5*x3 <= 250, "FillerConstraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Oil Paint Production: {x1.x:.2f} kg")
    print(f"Acrylic Paint Production: {x2.x:.2f} kg")
    print(f"Watercolor Paint Production: {x3.x:.2f} kg")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

