
from gurobipy import *

# Create a new model
m = Model("Paint_Manufacturing")

# Define the decision variables
x1 = m.addVar(name="Oil_Paintings", lb=0)
x2 = m.addVar(name="Acrylic_Paintings", lb=0)
x3 = m.addVar(name="Watercolor_Paintings", lb=0)

# Set the objective function
m.setObjective(150*x1 + 180*x2 + 220*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.5*x1 + 8*x2 + 16*x3 <= 350, name="Dye_Constraint")
m.addConstr(15*x1 + 12*x2 + 5*x3 <= 250, name="Filler_Constraint")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Value: {m.objVal}")
