
import gurobi

def solve_paint_manufacturer_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x1 = model.addVar(lb=0, name="oil_painting")
    x2 = model.addVar(lb=0, name="acrylic_painting")
    x3 = model.addVar(lb=0, name="watercolor_painting")

    # Objective function
    model.setObjective(150*x1 + 180*x2 + 220*x3, gurobi.GRB.MAXIMIZE)

    # Dye constraint
    model.addConstr(6.5*x1 + 8*x2 + 16*x3 <= 350, name="dye_constraint")

    # Filler constraint
    model.addConstr(15*x1 + 12*x2 + 5*x3 <= 250, name="filler_constraint")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oil Painting: {x1.varValue} kg")
        print(f"Acrylic Painting: {x2.varValue} kg")
        print(f"Watercolor Painting: {x3.varValue} kg")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_paint_manufacturer_problem()
