
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("coffee_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vanilla")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mocha")

# Set objective function
m.setObjective(2 * x + 3 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * x + 3 * y >= 60, "caffeine_constraint")
m.addConstr(2 * x + 5 * y >= 50, "sugar_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Vanilla Packages: {x.x:.2f}")
    print(f"Mocha Packages: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

