
from gurobipy import *

# Create a new model
m = Model("Coffee_Purchase_Optimization")

# Define the variables
V = m.addVar(vtype=GRB.CONTINUOUS, name="Vanilla", lb=0)
M = m.addVar(vtype=GRB.CONTINUOUS, name="Mocha", lb=0)

# Set the objective function
m.setObjective(2*V + 3*M, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*V + 3*M >= 60, "Caffeine_Constraint")
m.addConstr(2*V + 5*M >= 50, "Sugar_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {V.varName} = {V.x}, {M.varName} = {M.x}")
    print(f"Total cost: ${2*V.x + 3*M.x:.2f}")
else:
    print("No optimal solution found.")
