
import gurobi as gp

# Create a new model
model = gp.Model("coffee_problem")

# Define the decision variables
V = model.addVar(lb=0, name="Vanilla")
M = model.addVar(lb=0, name="Mocha")

# Objective: minimize cost
model.setObjective(2*V + 3*M, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(2*V + 3*M >= 60, name="caffeine_requirement")
model.addConstr(2*V + 5*M >= 50, name="sugar_requirement")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Buy {V.varValue:.0f} packages of Vanilla flavor coffee.")
    print(f"Buy {M.varValue:.0f} packages of Mocha flavor coffee.")
else:
    print("The problem is infeasible or no solution exists.")
