
import gurobipy as gp

# Create a new model
model = gp.Model("Gift_Delivery")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="postal_pickups")
y = model.addVar(vtype=gp.GRB.INTEGER, name="vans")

# Set the objective function
model.setObjective(100*x + 80*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(50*x + 40*y <= 1000, "budget_constraint")
model.addConstr(y <= x, "van_limit")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Postal Pickups (x): {x.x}")
    print(f"Number of Vans (y): {y.x}")
    print(f"Total Gifts Sent: {100*x.x + 80*y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

