
import gurobi

def solve_gift_distribution():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    P = model.addVar(name="P", vtype=gurobi.GRB.INTEGER, lb=0)  # Number of postal service pickups
    V = model.addVar(name="V", vtype=gurobi.GRB.INTEGER, lb=0)  # Number of vans

    # Objective function: Maximize the total number of gifts sent
    model.setObjective(100 * P + 80 * V, gurobi.GRB.MAXIMIZE)

    # Budget constraint: 50P + 40V <= 1000
    model.addConstraint(50 * P + 40 * V <= 1000, name="budget_constraint")

    # Vans cannot exceed postal service pickups: V <= P
    model.addConstraint(V <= P, name="vans_vs_postal")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: P = {P.varValue}, V = {V.varValue}")
        print(f"Maximum gifts sent: {100 * P.varValue + 80 * V.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is not optimal or infeasible.")

solve_gift_distribution()
