
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("SupplementOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Supplement_A")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Supplement_B")

# Set objective function
model.setObjective(3.5 * x + 3.8 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * x + 4 * y >= 25, "Calcium")
model.addConstr(2 * x + 1 * y >= 20, "Vitamin_A")
model.addConstr(3 * x + 2 * y >= 18, "Vitamin_B")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Supplement A: {x.x}")
    print(f"Number of Supplement B: {y.x}")
    print(f"Minimum Cost: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

