
from gurobipy import *

# Create a new model
m = Model("Supplement_Optimization")

# Define the decision variables
x_A = m.addVar(vtype=GRB.INTEGER, name="Supplement_A", lb=0)
x_B = m.addVar(vtype=GRB.INTEGER, name="Supplement_B", lb=0)

# Set the objective function
m.setObjective(3.50*x_A + 3.80*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x_A + 4*x_B >= 25, "Calcium_Requirement")
m.addConstr(2*x_A + 1*x_B >= 20, "Vitamin_A_Requirement")
m.addConstr(3*x_A + 2*x_B >= 18, "Vitamin_B_Requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x_A.x} of Supplement A")
    print(f"Buy {x_B.x} of Supplement B")
    print(f"Total cost: ${3.50*x_A.x + 3.80*x_B.x:.2f}")
else:
    print("No optimal solution found")

