
from gurobipy import Model, GRB

# Create a new model
m = Model("spelling_bee")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="x") # Number of short words
y = m.addVar(vtype=GRB.INTEGER, name="y") # Number of long words

# Set objective
m.setObjective(3*x + 6*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 5, "min_short")
m.addConstr(y >= 2, "min_long")
m.addConstr(x <= 10, "max_short")
m.addConstr(y <= 5, "max_long")
m.addConstr(x + y <= 10, "total_words")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Short words = {x.x}, Long words = {y.x}")
    print(f"Total points: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

