
from gurobipy import *

# Create a model
m = Model("Spelling_Bee_Optimization")

# Define the decision variables
x_s = m.addVar(lb=5, ub=10, vtype=GRB.INTEGER, name="short_words")
x_l = m.addVar(lb=2, ub=5, vtype=GRB.INTEGER, name="long_words")

# Set the objective function
m.setObjective(3*x_s + 6*x_l, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_s + x_l <= 10, "total_words_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x_s.varName} = {x_s.x}, {x_l.varName} = {x_l.x}")
    print(f"Maximum points: {m.objVal}")
else:
    print("No optimal solution found")
