
import gurobi

def solve_spelling_bee():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    S = model.addVar(lb=0, ub=None, name="Short_Words")
    L = model.addVar(lb=0, ub=None, name="Long_Words")

    # Objective function: Maximize 3S + 6L
    model.setObjective(3 * S + 6 * L, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(S >= 5, name="Min_Short_Words")
    model.addConstr(L >= 2, name="Min_Long_Words")
    model.addConstr(S <= 10, name="Max_Short_Words")
    model.addConstr(L <= 5, name="Max_Long_Words")
    model.addConstr(S + L <= 10, name="Total_Words")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Short words = {S.varValue}, Long words = {L.varValue}")
        print(f"Max points: {3 * S.varValue + 6 * L.varValue}")
    else:
        print("No optimal solution found")

solve_spelling_bee()
