
import gurobipy as gp

# Create a new model
m = gp.Model("Ice Cream Optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="chocolate")
y = m.addVar(vtype=gp.GRB.INTEGER, name="vanilla")

# Set objective function
m.setObjective(2*x + 1.5*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 30, "chocolate_min")
m.addConstr(x <= 50, "chocolate_max")
m.addConstr(y >= 20, "vanilla_min")
m.addConstr(y <= 60, "vanilla_max")
m.addConstr(x + y <= 70, "total_cones")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Chocolate Cones: {x.x}")
    print(f"Vanilla Cones: {y.x}")
    print(f"Total Profit: ${m.objVal}")
else:
    print("No solution found.")

