
from gurobipy import *

# Create a new model
m = Model("Ice Cream Sales")

# Define variables for the number of chocolate and vanilla cones sold
x = m.addVar(name="chocolate_cones", lb=30, ub=50)
y = m.addVar(name="vanilla_cones", lb=20, ub=60)

# Set the objective function to maximize profit
m.setObjective(2*x + 1.5*y, GRB.MAXIMIZE)

# Add constraint for total items sold
m.addConstr(x + y <= 70, name="total_items")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Sell {x.x} chocolate cones and {y.x} vanilla cones.")
else:
    print("No optimal solution found.")

