
import gurobipy as gp

# Create a new model
m = gp.Model("ice_cream_sales")

# Decision variables
x = m.addVar(lb=30, ub=50, name="chocolate_cones")
y = m.addVar(lb=20, ub=60, name="vanilla_cones")

# Objective function: Maximize profit
m.setObjective(2*x + 1.5*y, gp.GRB.MAXIMIZE)

# Constraint: Total cones sold cannot exceed 70
m.addConstraint(x + y <= 70)

# Solve the model
m.solve()

# Output the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Sell {x.varValue} chocolate cones and {y.varValue} vanilla cones.")
    print(f"Maximum profit: ${2*x.varValue + 1.5*y.varValue:.2f}")
else:
    print("No optimal solution found.")
