
from gurobipy import Model, GRB

# Create a new model
model = Model("brownie_optimization")

# Create decision variables
x = model.addVar(lb=0, ub=GRB.INFINITY, name="strawberry_brownies")
y = model.addVar(lb=0, ub=GRB.INFINITY, name="caramel_brownies")

# Set objective function
model.setObjective(1.5 * x + 2 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 50, "strawberry_demand")
model.addConstr(y >= 75, "caramel_demand")
model.addConstr(x <= 100, "strawberry_capacity")
model.addConstr(y <= 150, "caramel_capacity")
model.addConstr(x >= 2 * y, "production_ratio")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of strawberry brownies: {x.x}")
    print(f"Number of caramel brownies: {y.x}")
    print(f"Maximum Revenue: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

