
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define variables
x_s = m.addVar(lb=50, ub=100, vtype=GRB.INTEGER, name="strawberry_brownies")
x_c = m.addVar(lb=75, ub=150, vtype=GRB.INTEGER, name="caramel_brownies")

# Objective function: Maximize revenue
m.setObjective(1.5*x_s + 2*x_c, GRB.MAXIMIZE)

# Additional constraints
m.addConstr(x_s >= 2*x_c, "strawberry_at_least_twice_caramel")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strawberry brownies: {x_s.x}")
    print(f"Caramel brownies: {x_c.x}")
    print(f"Revenue: {m.ObjVal}")
else:
    print("No optimal solution found. The problem might be infeasible.")
