
import gurobi as gp

# Create a new model
m = gp.Model("Brownie_Optimization")

# Define variables
S = m.addVar(lb=0, ub=100, name="Strawberry_Brownies", vtype=gp.GRB.CONTINUOUS)
C = m.addVar(lb=0, ub=150, name="Caramel_Brownies", vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize 1.5S + 2C
m.setObjective(1.5*S + 2*C, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(S >= 50, name="Min_Strawberry")
m.addConstr(C >= 75, name="Min_Caramel")
m.addConstr(S <= 100, name="Max_Strawberry")
m.addConstr(C <= 150, name="Max_Caramel")
m.addConstr(S >= 2*C, name="Strawberry_vs_Caramel")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Strawberry Brownies: {S.varValue}")
    print(f"Caramel Brownies: {C.varValue}")
    print(f"Max Revenue: {m.objVal}")
else:
    print("No optimal solution found.")
