
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("NecklaceProduction")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="platinum_necklaces")  # Platinum necklaces
y = m.addVar(vtype=GRB.CONTINUOUS, name="silver_necklaces")  # Silver necklaces

# Set objective function
m.setObjective(2000*x + 700*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x + 7*y <= 35, "designing_time")
m.addConstr(15*x + 5*y <= 40, "crafting_time")
m.addConstr(x >= 0, "platinum_non_negative")  # Ensure non-negative number of necklaces
m.addConstr(y >= 0, "silver_non_negative")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Solution:")
    print(f"Platinum Necklaces: {x.x}")
    print(f"Silver Necklaces: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")

