
from gurobipy import *

# Create a new model
m = Model("Necklace_Production")

# Define the decision variables
P = m.addVar(vtype=GRB.INTEGER, name="Platinum_Necklaces")
S = m.addVar(vtype=GRB.INTEGER, name="Silver_Necklaces")

# Set the objective function
m.setObjective(2000*P + 700*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*P + 7*S <= 35, "Designing_Team_Constraint")
m.addConstr(15*P + 5*S <= 40, "Crafting_Team_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Platinum Necklaces: {P.x}")
    print(f"Silver Necklaces: {S.x}")
    print(f"Maximum Profit: ${2000*P.x + 700*S.x}")
else:
    print("No optimal solution found")
