
import gurobi

def solve_necklace_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, name="P", vtype=gurobi.GRB.CONTINUOUS)
    S = model.addVar(lb=0, name="S", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 2000P + 700S
    model.setObjective(2000 * P + 700 * S, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * P + 7 * S <= 35, name="Design_Time")
    model.addConstr(15 * P + 5 * S <= 40, name="Craft_Time")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Platinum Necklaces: {P.varValue}")
        print(f"Silver Necklaces: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_necklace_problem()
