
import gurobipy as gp

# Create a new model
model = gp.Model("Capsule Mixing")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Capsule_A")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Capsule_B")

# Set objective function
model.setObjective(2*x + 3*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x + 3*y >= 20, "Targeted_Medicine")
model.addConstr(3*x + y >= 20, "Pain_Reliever")
model.addConstr(x + 3*y >= 15, "Filler")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal:.2f}")
    print(f"Number of Capsule A: {x.x:.2f}")
    print(f"Number of Capsule B: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

