
from gurobipy import *

# Create a model
m = Model("Pharmacy_Mix")

# Define variables
x_A = m.addVar(name="Capsule_A", vtype=GRB.CONTINUOUS, lb=0)
x_B = m.addVar(name="Capsule_B", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(2*x_A + 3*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x_A + 3*x_B >= 20, name="Targeted_Medicine")
m.addConstr(3*x_A + 1*x_B >= 20, name="Pain_Reliever")
m.addConstr(1*x_A + 3*x_B >= 15, name="Filler")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Capsule A: {x_A.x}")
    print(f"Capsule B: {x_B.x}")
    print(f"Total Cost: ${2*x_A.x + 3*x_B.x:.2f}")
else:
    print("No optimal solution found")

