
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="x")  # Number of capsules A
y = model.addVar(lb=0, name="y")  # Number of capsules B

# Objective function: Minimize 2x + 3y
model.setObjective(2*x + 3*y, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(2*x + 3*y >= 20, name="medicine_constraint")
model.addConstr(3*x + y >= 20, name="pain_reliever_constraint")
model.addConstr(x + 3*y >= 15, name="filler_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of capsules A: {x.varValue}")
    print(f"Number of capsules B: {y.varValue}")
    print(f"Optimal cost: {model.objVal}")
else:
    print("No optimal solution found.")
