
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tool_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="hammers")  # Packages of hammers
y = m.addVar(vtype=GRB.CONTINUOUS, name="screwdrivers") # Packages of screwdrivers

# Set objective function
m.setObjective(72*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(28*x + 23*y <= 720, "lathe_constraint")
m.addConstr(82*x + 76*y <= 720, "cng_constraint")
m.addConstr(x >= 0, "hammers_nonnegative")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "screwdrivers_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Hammer Packages: {x.x}")
    print(f"Number of Screwdriver Packages: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

