
from gurobipy import *

# Create a new model
m = Model("Tool_Manufacturing")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="hammers")
y = m.addVar(vtype=GRB.CONTINUOUS, name="screwdrivers")

# Set the objective function to maximize profit
m.setObjective(72*x + 70*y, GRB.MAXIMIZE)

# Add constraints for machine availability
m.addConstr(28*x + 23*y <= 720, "lathe_limit")
m.addConstr(82*x + 76*y <= 720, "cng_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x.x:.2f} packages of hammers and {y.x:.2f} packages of screwdrivers.")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")

