
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x = model.addVar(name="x", lb=0, ub=None, obj=72)  # number of packages of hammers
y = model.addVar(name="y", lb=0, ub=None, obj=70)  # number of packages of screwdrivers

# Define the constraints
lathe_constraint = model.addConstr(28*x + 23*y <= 720, name="lathe_constraint")
cng_constraint = model.addConstr(82*x + 76*y <= 720, name="cng_constraint")

# Set the objective function
model.setObjective(72*x + 70*y, gurobi.GRB.MAXIMIZE)

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of packages of hammers: {x.varValue}")
    print(f"Number of packages of screwdrivers: {y.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
