
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Chicken Transport")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="train_trips")  # Number of train trips
y = m.addVar(vtype=GRB.INTEGER, name="truck_trips")  # Number of truck trips

# Set objective function
m.setObjective(500*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x + 80*y <= 2000, "budget")
m.addConstr(x <= y, "train_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of train trips (x): {x.x}")
    print(f"Number of truck trips (y): {y.x}")
    print(f"Total chickens transported: {500*x.x + 300*y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

