
from gurobipy import *

# Create a new model
m = Model("Chicken_Transport")

# Define variables
T = m.addVar(vtype=GRB.INTEGER, name="Train_Trips")
K = m.addVar(vtype=GRB.INTEGER, name="Truck_Trips")

# Objective function: Maximize the total number of chickens transported
m.setObjective(500*T + 300*K, GRB.MAXIMIZE)

# Constraints
m.addConstr(100*T + 80*K <= 2000, "Budget_Constraint")
m.addConstr(T <= K, "Train_vs_Truck_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Train Trips: {T.x}")
    print(f"Number of Truck Trips: {K.x}")
    print(f"Total Chickens Transported: {500*T.x + 300*K.x}")
else:
    print("No optimal solution found")
