
import gurobi

def solve_transportation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables: T (train trips) and K (truck trips)
    T = model.addVar(name="T", vtype=gurobi.GRB.INTEGER, lb=0)
    K = model.addVar(name="K", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective: Maximize 500T + 300K
    model.setObjective(500*T + 300*K, gurobi.GRB.MAXIMIZE)

    # Budget constraint: 100T + 80K <= 2000
    model.addConstr(100*T + 80*K <= 2000, name="budget_constraint")

    # Train trips cannot exceed truck trips: T <= K
    model.addConstr(T <= K, name="train_truck_constraint")

    # Solve the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal solution: Train trips = {T.varValue}, Truck trips = {K.varValue}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is not optimal or infeasible.")

solve_transportation_problem()
