
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("GummyBearProduction")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="fruit_gummy")  # Fruit gummy packets
y = model.addVar(vtype=GRB.INTEGER, name="sour_gummy")  # Sour gummy packets

# Set objective function
model.setObjective(1*x + 1.25*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 2000, "time_constraint")
model.addConstr(x <= 120, "fruit_limit")
model.addConstr(y <= 70, "sour_limit")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {x.x} packets of fruit gummy bears")
    print(f"Produce {y.x} packets of sour gummy bears")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {model.status}")

