
from gurobipy import *

# Create a new model
m = Model("Gummy_Bears_Profit")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="fruit_gummy_bears", lb=0)
y = m.addVar(vtype=GRB.INTEGER, name="sour_gummy_bears", lb=0)

# Set the objective function: Maximize profit
m.setObjective(1*x + 1.25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 2000, "time_constraint")
m.addConstr(x <= 120, "fruit_quantity_constraint")
m.addConstr(y <= 70, "sour_quantity_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fruit gummy bears packets: {x.x}")
    print(f"Number of sour gummy bears packets: {y.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
