
import gurobi

def solve_gummy_bears_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="fruit_gummy_bears", lb=0, ub=120, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="sour_gummy_bears", lb=0, ub=70, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(1*x + 1.25*y, gurobi.GRB.MAXIMIZE)

    # Time constraint
    model.addConstr(10*x + 15*y <= 2000, name="time_constraint")

    # Production limits
    model.addConstr(x <= 120, name="fruit_limit")
    model.addConstr(y <= 70, name="sour_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_gummy_bears_problem()
