
import gurobipy as gp

# Create a new model
model = gp.Model("GiftBoxProduction")

# Create decision variables
x = model.addVar(lb=0, name="mall_kiosk_hours")
y = model.addVar(lb=0, name="flagship_store_hours")

# Set objective function
model.setObjective(150*x + 500*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5*x + 10*y >= 80, "small_boxes")
model.addConstr(6*x + 15*y >= 100, "medium_boxes")
model.addConstr(2*x + 9*y >= 50, "large_boxes")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Mall Kiosk Hours: {x.x}")
    print(f"Flagship Store Hours: {y.x}")
    print(f"Total Cost: ${model.objVal}")
else:
    print("Infeasible or unbounded")

