
from gurobipy import *

# Create a model
m = Model("Candy_Gift_Boxes")

# Define decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mall_kiosk_hours")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="flagship_store_hours")

# Objective function: Minimize cost
m.setObjective(150*x1 + 500*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 10*x2 >= 80, "small_gift_boxes")
m.addConstr(6*x1 + 15*x2 >= 100, "medium_gift_boxes")
m.addConstr(2*x1 + 9*x2 >= 50, "large_gift_boxes")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mall kiosk hours: {x1.x}")
    print(f"Flagship store hours: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")

