
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, name="mall_kiosk_hours")
    x2 = model.addVar(lb=0, name="flagship_store_hours")

    # Define the objective function
    model.setObjective(150 * x1 + 500 * x2, gurobi.GRB.MINIMIZE)

    # Add demand constraints
    model.addConstr(5 * x1 + 10 * x2 >= 80, name="small_gift_boxes")
    model.addConstr(6 * x1 + 15 * x2 >= 100, name="medium_gift_boxes")
    model.addConstr(2 * x1 + 9 * x2 >= 50, name="large_gift_boxes")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Mall Kiosk Hours: {x1.varValue}")
        print(f"Flagship Store Hours: {x2.varValue}")
        print(f"Total Cost: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_problem()
